---
generated_at: 2026-02-02 10:05:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：22-注意機構（Attention Mechanism）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **AdditiveAttentionの計算式詳細**：根拠不足（後半のコードを完全に読み込んでいない）

## 2) 参照した情報（Evidence一覧）
- E-01: `tensorflow/python/keras/layers/dense_attention.py` 行33-73（BaseDenseAttention docstring）
- E-02: `tensorflow/python/keras/layers/dense_attention.py` 行75-177（BaseDenseAttention実装）
- E-03: `tensorflow/python/keras/layers/dense_attention.py` 行219-353（Attentionクラス）
- E-04: `tensorflow/python/keras/layers/dense_attention.py` 行356以降（AdditiveAttentionクラス）
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` 行23

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Luong-styleとBahdanau-styleの2種類提供 | E-03, E-04 | ○ |
| C-02 | inputsはリスト形式で長さ2-3 | E-02 (行188-208) | ○ |
| C-03 | key省略時はvalueがkeyになる | E-02 (行149) | ○ |
| C-04 | causal=Trueで下三角マスク生成 | E-02 (行156-167) | ○ |
| C-05 | float16時パディング値65504 | E-02 (行125-126) | ○ |
| C-06 | float32時パディング値1e9 | E-02 (行128) | ○ |
| C-07 | softmaxでアテンション分布計算 | E-02 (行131) | ○ |
| C-08 | 学習時ドロップアウト適用 | E-02 (行133-137) | ○ |
| C-09 | Attention: matmul(query, key^T) | E-03 (行345) | ○ |
| C-10 | Attention: use_scaleでscale変数乗算 | E-03 (行326-331, 346-347) | ○ |
| C-11 | query_maskで出力ゼロ化 | E-02 (行171-174) | ○ |
| C-12 | return_attention_scoresでスコア返却 | E-02 (行175-176) | ○ |
| C-13 | Dense/CNN向けでRNN向けではない | E-01 (行36) | ○ |
| C-14 | supports_masking=True | E-02 (行80) | ○ |
| C-15 | AdditiveAttention: reduce_sum(tanh(query+key)) | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- AdditiveAttentionの_calculate_scores実装は356行目以降にあるが完全には読み込んでいない
  - 候補：`tensorflow/python/keras/layers/dense_attention.py` 行400以降

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Attentionクラスの実装は完全にソースコードで確認済み
- 1: 中リスク - AdditiveAttentionの計算式は追加確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] AdditiveAttentionの_calculate_scores実装が設計書記載と一致するか
- [ ] float16のパディング値が最新実装と合致しているか
- [ ] MultiHeadAttentionとの関係性の補足が必要か
